/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.types.Checksum;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.NodeKind;

public class Info
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String path;
    private String wcroot;
    private String url;
    private long rev;
    private NodeKind kind;
    private String reposRootUrl;
    private String reposUUID;
    private long lastChangedRev;
    private long lastChangedDate;
    private String lastChangedAuthor;
    private Lock lock;
    private boolean hasWcInfo;
    private ScheduleKind schedule;
    private String copyFromUrl;
    private long copyFromRev;
    private long textTime;
    private Checksum checksum;
    private String changelistName;
    private long workingSize;
    private long reposSize;
    private Depth depth;
    private Set<ConflictDescriptor> conflict;

    public Info(String path, String wcroot, String url, long rev, NodeKind kind, String reposRootUrl, String reposUUID, long lastChangedRev, long lastChangedDate, String lastChangedAuthor, Lock lock, boolean hasWcInfo, ScheduleKind schedule, String copyFromUrl, long copyFromRev, long textTime, Checksum checksum, String changelistName, long workingSize, long reposSize, Depth depth, Set<ConflictDescriptor> conflict) {
        this.path = path;
        this.wcroot = wcroot;
        this.url = url;
        this.rev = rev;
        this.kind = kind;
        this.reposRootUrl = reposRootUrl;
        this.reposUUID = reposUUID;
        this.lastChangedRev = lastChangedRev;
        this.lastChangedDate = lastChangedDate;
        this.lastChangedAuthor = lastChangedAuthor;
        this.lock = lock;
        this.hasWcInfo = hasWcInfo;
        this.schedule = schedule;
        this.copyFromUrl = copyFromUrl;
        this.copyFromRev = copyFromRev;
        this.textTime = textTime;
        this.checksum = checksum;
        this.changelistName = changelistName;
        this.workingSize = workingSize;
        this.reposSize = reposSize;
        this.depth = depth;
        this.conflict = conflict;
    }

    public String getPath() {
        return this.path;
    }

    public String getWcroot() {
        return this.wcroot;
    }

    public String getUrl() {
        return this.url;
    }

    public long getRev() {
        return this.rev;
    }

    public NodeKind getKind() {
        return this.kind;
    }

    public String getReposRootUrl() {
        return this.reposRootUrl;
    }

    public String getReposUUID() {
        return this.reposUUID;
    }

    public long getLastChangedRev() {
        return this.lastChangedRev;
    }

    public Date getLastChangedDate() {
        if (this.lastChangedDate == 0L) {
            return null;
        }
        return new Date(this.lastChangedDate / 1000L);
    }

    public long getLastChangedDateMicros() {
        return this.lastChangedDate;
    }

    public String getLastChangedAuthor() {
        return this.lastChangedAuthor;
    }

    public Lock getLock() {
        return this.lock;
    }

    public boolean isHasWcInfo() {
        return this.hasWcInfo;
    }

    public ScheduleKind getSchedule() {
        return this.schedule;
    }

    public String getCopyFromUrl() {
        return this.copyFromUrl;
    }

    public long getCopyFromRev() {
        return this.copyFromRev;
    }

    public Date getTextTime() {
        if (this.textTime == 0L) {
            return null;
        }
        return new Date(this.textTime / 1000L);
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    public String getChangelistName() {
        return this.changelistName;
    }

    public long getWorkingSize() {
        return this.workingSize;
    }

    public long getReposSize() {
        return this.reposSize;
    }

    public Depth getDepth() {
        return this.depth;
    }

    public Set<ConflictDescriptor> getConflicts() {
        return this.conflict;
    }

    public String toString() {
        return this.getUrl();
    }

    public static enum ScheduleKind {
        normal,
        add,
        delete,
        replace;

    }
}

