/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.ConflictResult;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.ISVNRemote;
import org.apache.subversion.javahl.NativeResources;
import org.apache.subversion.javahl.OperationContext;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.AuthnCallback;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.apache.subversion.javahl.callback.BlameLineCallback;
import org.apache.subversion.javahl.callback.BlameRangeCallback;
import org.apache.subversion.javahl.callback.ChangelistCallback;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.ConfigEvent;
import org.apache.subversion.javahl.callback.ConflictResolverCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.ImportFilterCallback;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.InheritedProplistCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.ListItemCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.PatchCallback;
import org.apache.subversion.javahl.callback.ProgressCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.callback.TunnelAgent;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DiffOptions;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.ExternalItem;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.RuntimeVersion;
import org.apache.subversion.javahl.types.Version;
import org.apache.subversion.javahl.types.VersionExtended;

public class SVNClient
implements ISVNClient {
    protected long cppAddr;
    private ClientContext clientContext = new ClientContext();

    public SVNClient() {
        this.cppAddr = this.ctNative();
        try {
            this.setConfigDirectory(null);
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    private long getCppAddr() {
        return this.cppAddr;
    }

    private native long ctNative();

    @Override
    public native void dispose();

    public native void finalize();

    @Override
    public Version getVersion() {
        return NativeResources.getVersion();
    }

    @Override
    public RuntimeVersion getRuntimeVersion() {
        return NativeResources.getRuntimeVersion();
    }

    @Override
    public native VersionExtended getVersionExtended(boolean var1);

    @Override
    public native String getAdminDirectoryName();

    @Override
    public native boolean isAdminDirectory(String var1);

    @Deprecated
    public native String getLastPath();

    @Override
    public native void status(String var1, Depth var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, Collection<String> var9, StatusCallback var10) throws ClientException;

    @Override
    @Deprecated
    public void status(String path, Depth depth, boolean onServer, boolean getAll, boolean noIgnore, boolean ignoreExternals, Collection<String> changelists, StatusCallback callback) throws ClientException {
        this.status(path, depth, onServer, true, getAll, noIgnore, ignoreExternals, false, changelists, callback);
    }

    @Override
    public native void list(String var1, Revision var2, Revision var3, List<String> var4, Depth var5, int var6, boolean var7, boolean var8, ListItemCallback var9) throws ClientException;

    @Override
    @Deprecated
    public void list(String url, Revision revision, Revision pegRevision, Depth depth, int direntFields, boolean fetchLocks, ListCallback callback) throws ClientException {
        this.list(url, revision, pegRevision, null, depth, direntFields, fetchLocks, false, new ListCallbackWrapper(callback));
    }

    @Override
    public native void username(String var1);

    @Override
    public native void password(String var1);

    @Override
    public native void setPrompt(AuthnCallback var1);

    @Override
    public native void setPrompt(UserPasswordCallback var1);

    @Override
    public native void setTunnelAgent(TunnelAgent var1);

    @Override
    @Deprecated
    public void logMessages(String path, Revision pegRevision, List<RevisionRange> ranges, boolean stopOnCopy, boolean discoverPath, boolean includeMergedRevisions, Set<String> revProps, long limit, LogMessageCallback callback) throws ClientException {
        this.logMessages(path, pegRevision, ranges, stopOnCopy, discoverPath, includeMergedRevisions, revProps, false, limit, callback);
    }

    @Override
    public native void logMessages(String var1, Revision var2, List<RevisionRange> var3, boolean var4, boolean var5, boolean var6, Set<String> var7, boolean var8, long var9, LogMessageCallback var11) throws ClientException;

    @Override
    public native long checkout(String var1, String var2, Revision var3, Revision var4, Depth var5, boolean var6, boolean var7) throws ClientException;

    @Override
    public void notification2(ClientNotifyCallback notify) {
        this.clientContext.notify = notify;
    }

    @Override
    public void setConflictResolver(ConflictResolverCallback resolver) {
        this.clientContext.resolver = resolver;
    }

    @Override
    public void setProgressCallback(ProgressCallback progress) {
        this.clientContext.setProgressCallback(progress);
    }

    @Override
    public native void remove(Set<String> var1, boolean var2, boolean var3, Map<String, String> var4, CommitMessageCallback var5, CommitCallback var6) throws ClientException;

    @Override
    public native void revert(Set<String> var1, Depth var2, Collection<String> var3, boolean var4, boolean var5) throws ClientException;

    @Override
    public void revert(Set<String> paths, Depth depth, Collection<String> changelists) throws ClientException {
        this.revert(paths, depth, changelists, false, false);
    }

    @Override
    public void revert(String path, Depth depth, Collection<String> changelists) throws ClientException {
        this.revert(Collections.singleton(path), depth, changelists, false, false);
    }

    @Override
    public native void add(String var1, Depth var2, boolean var3, boolean var4, boolean var5, boolean var6) throws ClientException;

    @Override
    public void add(String path, Depth depth, boolean force, boolean noIgnores, boolean addParents) throws ClientException {
        this.add(path, depth, force, noIgnores, false, addParents);
    }

    @Override
    public native long[] update(Set<String> var1, Revision var2, Depth var3, boolean var4, boolean var5, boolean var6, boolean var7) throws ClientException;

    @Override
    public native void commit(Set<String> var1, Depth var2, boolean var3, boolean var4, Collection<String> var5, Map<String, String> var6, CommitMessageCallback var7, CommitCallback var8) throws ClientException;

    @Override
    public native void copy(List<CopySource> var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, Map<String, List<ExternalItem>> var8, Map<String, String> var9, CommitMessageCallback var10, CommitCallback var11) throws ClientException;

    @Override
    public void copy(List<CopySource> sources, String destPath, boolean copyAsChild, boolean makeParents, boolean ignoreExternals, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.copy(sources, destPath, copyAsChild, makeParents, ignoreExternals, false, false, null, revpropTable, handler, callback);
    }

    @Override
    public native void move(Set<String> var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, Map<String, String> var8, CommitMessageCallback var9, CommitCallback var10) throws ClientException;

    @Override
    @Deprecated
    public void move(Set<String> srcPaths, String destPath, boolean force, boolean moveAsChild, boolean makeParents, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.move(srcPaths, destPath, force, moveAsChild, makeParents, false, true, revpropTable, handler, callback);
    }

    @Override
    public native void mkdir(Set<String> var1, boolean var2, Map<String, String> var3, CommitMessageCallback var4, CommitCallback var5) throws ClientException;

    @Override
    public native void cleanup(String var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6) throws ClientException;

    @Override
    public void cleanup(String path) throws ClientException {
        this.cleanup(path, true, true, true, true, false);
    }

    @Override
    public native void resolve(String var1, Depth var2, ConflictResult.Choice var3) throws SubversionException;

    @Override
    public native long doExport(String var1, String var2, Revision var3, Revision var4, boolean var5, boolean var6, boolean var7, Depth var8, String var9) throws ClientException;

    @Override
    public long doExport(String srcPath, String destPath, Revision revision, Revision pegRevision, boolean force, boolean ignoreExternals, Depth depth, String nativeEOL) throws ClientException {
        return this.doExport(srcPath, destPath, revision, pegRevision, force, ignoreExternals, false, depth, nativeEOL);
    }

    @Override
    public native long doSwitch(String var1, String var2, Revision var3, Revision var4, Depth var5, boolean var6, boolean var7, boolean var8, boolean var9) throws ClientException;

    @Override
    public native void doImport(String var1, String var2, Depth var3, boolean var4, boolean var5, boolean var6, Map<String, String> var7, ImportFilterCallback var8, CommitMessageCallback var9, CommitCallback var10) throws ClientException;

    @Override
    public void doImport(String path, String url, Depth depth, boolean noIgnore, boolean ignoreUnknownNodeTypes, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.doImport(path, url, depth, noIgnore, false, ignoreUnknownNodeTypes, revpropTable, null, handler, callback);
    }

    @Override
    public native Set<String> suggestMergeSources(String var1, Revision var2) throws SubversionException;

    @Override
    public native void merge(String var1, Revision var2, String var3, Revision var4, String var5, boolean var6, Depth var7, boolean var8, boolean var9, boolean var10, boolean var11, boolean var12) throws ClientException;

    @Override
    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, Depth depth, boolean ignoreMergeinfo, boolean diffIgnoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, depth, ignoreMergeinfo, diffIgnoreAncestry, dryRun, true, recordOnly);
    }

    @Override
    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, Depth depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, depth, ignoreAncestry, ignoreAncestry, dryRun, recordOnly);
    }

    @Override
    public native void merge(String var1, Revision var2, List<RevisionRange> var3, String var4, boolean var5, Depth var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11) throws ClientException;

    @Override
    public void merge(String path, Revision pegRevision, List<RevisionRange> revisions, String localPath, boolean force, Depth depth, boolean ignoreMergeinfo, boolean diffIgnoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        this.merge(path, pegRevision, revisions, localPath, force, depth, ignoreMergeinfo, diffIgnoreAncestry, dryRun, true, recordOnly);
    }

    @Override
    public void merge(String path, Revision pegRevision, List<RevisionRange> revisions, String localPath, boolean force, Depth depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        this.merge(path, pegRevision, revisions, localPath, force, depth, ignoreAncestry, ignoreAncestry, dryRun, recordOnly);
    }

    @Override
    @Deprecated
    public native void mergeReintegrate(String var1, Revision var2, String var3, boolean var4) throws ClientException;

    @Override
    public native Mergeinfo getMergeinfo(String var1, Revision var2) throws SubversionException;

    @Override
    public native void getMergeinfoLog(Mergeinfo.LogKind var1, String var2, Revision var3, String var4, Revision var5, Revision var6, Revision var7, boolean var8, Depth var9, Set<String> var10, LogMessageCallback var11) throws ClientException;

    @Override
    public void getMergeinfoLog(Mergeinfo.LogKind kind, String pathOrUrl, Revision pegRevision, String mergeSourceUrl, Revision srcPegRevision, boolean discoverChangedPaths, Depth depth, Set<String> revProps, LogMessageCallback callback) throws ClientException {
        Revision unspecified = new Revision(Revision.Kind.unspecified);
        this.getMergeinfoLog(kind, pathOrUrl, pegRevision, mergeSourceUrl, srcPegRevision, unspecified, unspecified, discoverChangedPaths, depth, revProps, callback);
    }

    @Override
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds) throws ClientException {
        try {
            FileOutputStream stream = new FileOutputStream(outFileName);
            this.diff(target1, revision1, target2, revision2, relativeToDir, (OutputStream)stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, false, false, null);
        }
        catch (FileNotFoundException ex) {
            throw ClientException.fromException(ex);
        }
    }

    @Override
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, OutputStream stream, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly) throws ClientException {
        this.diff(target1, revision1, target2, revision2, relativeToDir, stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, ignoreProps, propsOnly, null);
    }

    @Override
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly, DiffOptions options) throws ClientException {
        try {
            FileOutputStream stream = new FileOutputStream(outFileName);
            this.diff(target1, revision1, target2, revision2, relativeToDir, (OutputStream)stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, ignoreProps, propsOnly, options);
        }
        catch (FileNotFoundException ex) {
            throw ClientException.fromException(ex);
        }
    }

    @Override
    public native void diff(String var1, Revision var2, String var3, Revision var4, String var5, OutputStream var6, Depth var7, Collection<String> var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13, boolean var14, DiffOptions var15) throws ClientException;

    @Override
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds) throws ClientException {
        try {
            FileOutputStream stream = new FileOutputStream(outFileName);
            this.diff(target, pegRevision, startRevision, endRevision, relativeToDir, (OutputStream)stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, false, false, null);
        }
        catch (FileNotFoundException ex) {
            throw ClientException.fromException(ex);
        }
    }

    @Override
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, OutputStream stream, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly) throws ClientException {
        this.diff(target, pegRevision, startRevision, endRevision, relativeToDir, stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, ignoreProps, propsOnly, null);
    }

    @Override
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly, DiffOptions options) throws ClientException {
        try {
            FileOutputStream stream = new FileOutputStream(outFileName);
            this.diff(target, pegRevision, startRevision, endRevision, relativeToDir, (OutputStream)stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, ignoreProps, propsOnly, options);
        }
        catch (FileNotFoundException ex) {
            throw ClientException.fromException(ex);
        }
    }

    @Override
    public native void diff(String var1, Revision var2, Revision var3, Revision var4, String var5, OutputStream var6, Depth var7, Collection<String> var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13, boolean var14, DiffOptions var15) throws ClientException;

    @Override
    public native void diffSummarize(String var1, Revision var2, String var3, Revision var4, Depth var5, Collection<String> var6, boolean var7, DiffSummaryCallback var8) throws ClientException;

    @Override
    public native void diffSummarize(String var1, Revision var2, Revision var3, Revision var4, Depth var5, Collection<String> var6, boolean var7, DiffSummaryCallback var8) throws ClientException;

    @Override
    public native void properties(String var1, Revision var2, Revision var3, Depth var4, Collection<String> var5, ProplistCallback var6) throws ClientException;

    @Override
    public native void properties(String var1, Revision var2, Revision var3, Depth var4, Collection<String> var5, InheritedProplistCallback var6) throws ClientException;

    @Override
    public native void propertySetLocal(Set<String> var1, String var2, byte[] var3, Depth var4, Collection<String> var5, boolean var6) throws ClientException;

    @Override
    public native void propertySetRemote(String var1, long var2, String var4, byte[] var5, CommitMessageCallback var6, boolean var7, Map<String, String> var8, CommitCallback var9) throws ClientException;

    @Override
    public native byte[] revProperty(String var1, String var2, Revision var3) throws ClientException;

    @Override
    public native Map<String, byte[]> revProperties(String var1, Revision var2) throws ClientException;

    @Override
    public native void setRevProperty(String var1, String var2, Revision var3, String var4, String var5, boolean var6) throws ClientException;

    @Override
    public byte[] propertyGet(String path, String name, Revision revision, Revision pegRevision) throws ClientException {
        return this.propertyGet(path, name, revision, pegRevision, null);
    }

    @Override
    public native byte[] propertyGet(String var1, String var2, Revision var3, Revision var4, Collection<String> var5) throws ClientException;

    @Override
    public byte[] fileContent(String path, Revision revision, Revision pegRevision) throws ClientException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.streamFileContent(path, revision, pegRevision, true, false, stream);
        return stream.toByteArray();
    }

    @Override
    public native Map<String, byte[]> streamFileContent(String var1, Revision var2, Revision var3, boolean var4, boolean var5, OutputStream var6) throws ClientException;

    @Override
    public void streamFileContent(String path, Revision revision, Revision pegRevision, OutputStream stream) throws ClientException {
        this.streamFileContent(path, revision, pegRevision, true, false, stream);
    }

    @Override
    public native void relocate(String var1, String var2, String var3, boolean var4) throws ClientException;

    @Override
    @Deprecated
    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions, BlameCallback callback) throws ClientException {
        this.blame(path, pegRevision, revisionStart, revisionEnd, ignoreMimeType, includeMergedRevisions, callback, null);
    }

    @Override
    @Deprecated
    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions, BlameCallback callback, DiffOptions options) throws ClientException {
        this.blame(path, pegRevision, revisionStart, revisionEnd, ignoreMimeType, includeMergedRevisions, options, null, new BlameCallbackAdapter(callback));
    }

    @Override
    public native void blame(String var1, Revision var2, Revision var3, Revision var4, boolean var5, boolean var6, DiffOptions var7, BlameRangeCallback var8, BlameLineCallback var9) throws ClientException;

    @Override
    public native void setConfigDirectory(String var1) throws ClientException;

    @Override
    public native String getConfigDirectory() throws ClientException;

    @Override
    public native void setConfigEventHandler(ConfigEvent var1) throws ClientException;

    @Override
    public native ConfigEvent getConfigEventHandler() throws ClientException;

    @Override
    public native void cancelOperation() throws ClientException;

    @Override
    public native void addToChangelist(Set<String> var1, String var2, Depth var3, Collection<String> var4) throws ClientException;

    @Override
    public native void removeFromChangelists(Set<String> var1, Depth var2, Collection<String> var3) throws ClientException;

    @Override
    public native void getChangelists(String var1, Collection<String> var2, Depth var3, ChangelistCallback var4) throws ClientException;

    @Override
    public native String getVersionInfo(String var1, String var2, boolean var3) throws ClientException;

    @Override
    public native void upgrade(String var1) throws ClientException;

    public static native void enableLogging(ClientLogLevel var0, String var1);

    public static native String version();

    public static native int versionMajor();

    public static native int versionMinor();

    public static native int versionMicro();

    @Override
    public native void lock(Set<String> var1, String var2, boolean var3) throws ClientException;

    @Override
    public native void unlock(Set<String> var1, boolean var2) throws ClientException;

    @Override
    public native void info(String var1, Revision var2, Revision var3, Depth var4, boolean var5, boolean var6, boolean var7, Collection<String> var8, InfoCallback var9) throws ClientException;

    @Override
    public void info2(String pathOrUrl, Revision revision, Revision pegRevision, Depth depth, Collection<String> changelists, InfoCallback callback) throws ClientException {
        this.info(pathOrUrl, revision, pegRevision, depth, false, true, false, changelists, callback);
    }

    @Override
    public native void patch(String var1, String var2, boolean var3, int var4, boolean var5, boolean var6, boolean var7, PatchCallback var8) throws ClientException;

    @Override
    public native void vacuum(String var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6) throws ClientException;

    @Override
    public ISVNRemote openRemoteSession(String pathOrUrl) throws ClientException, SubversionException {
        return this.nativeOpenRemoteSession(pathOrUrl, 1);
    }

    @Override
    public ISVNRemote openRemoteSession(String pathOrUrl, int retryAttempts) throws ClientException, SubversionException {
        if (retryAttempts <= 0) {
            throw new IllegalArgumentException("retryAttempts must be positive");
        }
        return this.nativeOpenRemoteSession(pathOrUrl, retryAttempts);
    }

    private native ISVNRemote nativeOpenRemoteSession(String var1, int var2) throws ClientException, SubversionException;

    static {
        NativeResources.loadNativeLibrary();
    }

    private class ClientContext
    extends OperationContext
    implements ClientNotifyCallback,
    ConflictResolverCallback {
        public ClientNotifyCallback notify = null;
        public ConflictResolverCallback resolver = null;

        private ClientContext() {
        }

        @Override
        public void onNotify(ClientNotifyInformation notifyInfo) {
            if (this.notify != null) {
                this.notify.onNotify(notifyInfo);
            }
        }

        @Override
        public ConflictResult resolve(ConflictDescriptor conflict) throws SubversionException {
            if (this.resolver != null) {
                return this.resolver.resolve(conflict);
            }
            return new ConflictResult(ConflictResult.Choice.postpone, null);
        }
    }

    private final class ListCallbackWrapper
    implements ListItemCallback {
        private final ListCallback wrappedCallback;

        ListCallbackWrapper(ListCallback wrappedCallback) {
            this.wrappedCallback = wrappedCallback;
        }

        @Override
        public void doEntry(DirEntry dirent, Lock lock, String externalParentURL, String externalTarget) {
            this.wrappedCallback.doEntry(dirent, lock);
        }
    }

    @Deprecated
    private class BlameCallbackAdapter
    implements BlameLineCallback {
        private BlameCallback wrappedCallback = null;

        public BlameCallbackAdapter(BlameCallback callback) {
            this.wrappedCallback = callback;
        }

        @Override
        public void singleLine(long lineNum, long revision, Map<String, byte[]> revProps, long mergedRevision, Map<String, byte[]> mergedRevProps, String mergedPath, boolean localChange, byte[] line) throws ClientException {
            if (this.wrappedCallback == null) {
                return;
            }
            String convertedLine = null;
            try {
                convertedLine = new String(line, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw ClientException.fromException(ex);
            }
            this.wrappedCallback.singleLine(lineNum, revision, revProps, mergedRevision, mergedRevProps, mergedPath, convertedLine, localChange);
        }
    }

    public static enum ClientLogLevel {
        NoLog,
        ErrorLog,
        ExceptionLog,
        EntryLog;

    }
}

