/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import jdbm.recman.BlockIo;
import jdbm.recman.RecordFile;

public final class TransactionManager {
    private RecordFile owner;
    private FileOutputStream fos;
    private ObjectOutputStream oos;
    static final int DEFAULT_TXNS_IN_LOG = 10;
    private int _maxTxns = 10;
    private ArrayList<BlockIo>[] txns = new ArrayList[10];
    private int curTxn = -1;
    static final String extension = ".lg";

    TransactionManager(RecordFile owner) throws IOException {
        this.owner = owner;
        this.recover();
        this.open();
    }

    public void synchronizeLog() throws IOException {
        this.synchronizeLogFromMemory();
    }

    public void setMaximumTransactionsInLog(int maxTxns) throws IOException {
        if (maxTxns <= 0) {
            throw new IllegalArgumentException("Argument 'maxTxns' must be greater than 0.");
        }
        if (this.curTxn != -1) {
            throw new IllegalStateException("Cannot change setting while transactions are pending in the log");
        }
        this._maxTxns = maxTxns;
        this.txns = new ArrayList[maxTxns];
    }

    private String makeLogName() {
        return this.owner.getFileName() + extension;
    }

    private void synchronizeLogFromMemory() throws IOException {
        this.close();
        TreeSet<BlockIo> blockList = new TreeSet<BlockIo>(new BlockIoComparator());
        int numBlocks = 0;
        int writtenBlocks = 0;
        for (int i = 0; i < this._maxTxns; ++i) {
            if (this.txns[i] == null) continue;
            for (BlockIo block : this.txns[i]) {
                if (blockList.contains(block)) {
                    block.decrementTransactionCount();
                } else {
                    ++writtenBlocks;
                    blockList.add(block);
                }
                ++numBlocks;
            }
            this.txns[i] = null;
        }
        this.synchronizeBlocks(blockList.iterator(), true);
        this.owner.sync();
        this.open();
    }

    private void open() throws IOException {
        this.fos = new FileOutputStream(this.makeLogName());
        this.oos = new ObjectOutputStream(this.fos);
        this.oos.writeShort(4960);
        this.oos.flush();
        this.curTxn = -1;
    }

    /*
     * Exception decompiling
     */
    private void recover() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void synchronizeBlocks(Iterator<BlockIo> blockIterator, boolean fromCore) throws IOException {
        while (blockIterator.hasNext()) {
            BlockIo cur = blockIterator.next();
            this.owner.synch(cur);
            if (!fromCore) continue;
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur, true);
        }
    }

    private void setClean(ArrayList<BlockIo> blocks) throws IOException {
        for (BlockIo cur : blocks) {
            cur.setClean();
        }
    }

    private void discardBlocks(ArrayList<BlockIo> blocks) throws IOException {
        for (BlockIo cur : blocks) {
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur, false);
        }
    }

    void start() throws IOException {
        ++this.curTxn;
        if (this.curTxn == this._maxTxns) {
            this.synchronizeLogFromMemory();
            this.curTxn = 0;
        }
        this.txns[this.curTxn] = new ArrayList();
    }

    void add(BlockIo block) throws IOException {
        block.incrementTransactionCount();
        this.txns[this.curTxn].add(block);
    }

    void commit() throws IOException {
        this.oos.writeObject(this.txns[this.curTxn]);
        this.sync();
        this.setClean(this.txns[this.curTxn]);
        this.oos = new ObjectOutputStream(this.fos);
    }

    private void sync() throws IOException {
        this.oos.flush();
        this.fos.flush();
        this.fos.getFD().sync();
    }

    void shutdown() throws IOException {
        this.synchronizeLogFromMemory();
        this.close();
    }

    private void close() throws IOException {
        this.sync();
        this.oos.close();
        this.fos.close();
        this.oos = null;
        this.fos = null;
    }

    void forceClose() throws IOException {
        this.oos.close();
        this.fos.close();
        this.oos = null;
        this.fos = null;
    }

    void synchronizeLogFromDisk() throws IOException {
        this.close();
        for (int i = 0; i < this._maxTxns; ++i) {
            if (this.txns[i] == null) continue;
            this.discardBlocks(this.txns[i]);
            this.txns[i] = null;
        }
        this.recover();
        this.open();
    }

    public static class BlockIoComparator
    implements Comparator<BlockIo> {
        @Override
        public int compare(BlockIo block1, BlockIo block2) {
            int result = 0;
            result = block1.getBlockId() == block2.getBlockId() ? 0 : (block1.getBlockId() < block2.getBlockId() ? -1 : 1);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

