/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper.maps;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import jdbm.helper.maps.AbstractLongKeyMap;
import jdbm.helper.maps.AbstractLongSet;
import jdbm.helper.maps.DefaultLongHashFunction;
import jdbm.helper.maps.Exceptions;
import jdbm.helper.maps.LongHashFunction;
import jdbm.helper.maps.LongIterator;
import jdbm.helper.maps.LongKeyMap;
import jdbm.helper.maps.LongKeyMapIterator;
import jdbm.helper.maps.LongSet;
import jdbm.helper.maps.Primes;

public final class LongKeyChainedHashMap<E>
extends AbstractLongKeyMap<E>
implements LongKeyMap<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 5732061193461471028L;
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private LongHashFunction keyhash;
    private int size;
    private transient Entry<E>[] data;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient LongSet keys;
    private transient Collection<E> values;

    private LongKeyChainedHashMap(LongHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        this.data = this.makeEntryArray(capacity);
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
    }

    private LongKeyChainedHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultLongHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public LongKeyChainedHashMap() {
        this(11);
    }

    public LongKeyChainedHashMap(LongKeyMap<E> map) {
        this();
        this.putAll(map);
    }

    public LongKeyChainedHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public LongKeyChainedHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public LongKeyChainedHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public LongKeyChainedHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public LongKeyChainedHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public LongKeyChainedHashMap(LongHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public LongKeyChainedHashMap(LongHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public LongKeyChainedHashMap(LongHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public LongKeyChainedHashMap(LongHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public LongKeyChainedHashMap(LongHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public LongKeyChainedHashMap(LongHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            Entry<E>[] newdata = this.makeEntryArray(newcapacity);
            for (int i = 0; i < this.data.length; ++i) {
                Entry<E> e = this.data[i];
                while (e != null) {
                    int index = Math.abs(this.keyhash.hash(e.key)) % newdata.length;
                    Entry next = e.next;
                    e.next = newdata[index];
                    newdata[index] = e;
                    e = next;
                }
            }
            this.data = newdata;
        }
    }

    private Entry<E>[] makeEntryArray(int newcapacity) {
        return new Entry[newcapacity];
    }

    private Entry<E> removeList(Entry<E> list, Entry<E> e) {
        if (list == e) {
            list = e.next;
            e.next = null;
            return list;
        }
        Entry<E> listStart = list;
        while (list.next != e) {
            list = list.next;
        }
        list.next = e.next;
        e.next = null;
        return listStart;
    }

    private Entry<E> searchList(Entry<E> list, long key) {
        while (list != null) {
            if (list.key == key) {
                return list;
            }
            list = list.next;
        }
        return null;
    }

    private Entry<E> getEntry(long key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        return this.searchList(this.data[index], key);
    }

    @Override
    public LongSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public E put(long key, E value) {
        E result;
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry<E> e = this.searchList(this.data[index], key);
        if (e == null) {
            result = null;
            e = new Entry<E>(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            this.ensureCapacity(this.size + 1);
            ++this.size;
        } else {
            result = e.value;
            e.value = value;
        }
        return result;
    }

    @Override
    public Collection<E> values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public Object clone() {
        try {
            LongKeyChainedHashMap c = (LongKeyChainedHashMap)super.clone();
            c.data = this.makeEntryArray(this.data.length);
            for (int i = 0; i < this.data.length; ++i) {
                c.data[i] = this.cloneList(this.data[i]);
            }
            c.values = null;
            c.keys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    private Entry<E> cloneList(Entry<E> e) {
        if (e == null) {
            return null;
        }
        Entry<E> ne = new Entry<E>(e.getKey(), e.getValue());
        ne.next = this.cloneList(e.next);
        return ne;
    }

    @Override
    public LongKeyMapIterator<E> entries() {
        return new LongKeyMapIterator<E>(){
            Entry<E> currEntry = null;
            int nextList = this.nextList(0);
            Entry<E> nextEntry = this.nextList == -1 ? null : LongKeyChainedHashMap.access$200(LongKeyChainedHashMap.this)[this.nextList];

            int nextList(int index) {
                while (index < LongKeyChainedHashMap.this.data.length && LongKeyChainedHashMap.this.data[index] == null) {
                    ++index;
                }
                return index < LongKeyChainedHashMap.this.data.length ? index : -1;
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != null;
            }

            @Override
            public void next() {
                if (this.nextEntry == null) {
                    Exceptions.endOfIterator();
                }
                this.currEntry = this.nextEntry;
                this.nextEntry = this.nextEntry.next;
                if (this.nextEntry == null) {
                    this.nextList = this.nextList(this.nextList + 1);
                    if (this.nextList != -1) {
                        this.nextEntry = LongKeyChainedHashMap.this.data[this.nextList];
                    }
                }
            }

            @Override
            public long getKey() {
                if (this.currEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.currEntry.getKey();
            }

            @Override
            public E getValue() {
                if (this.currEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.currEntry.getValue();
            }

            @Override
            public void remove() {
                if (this.currEntry == null) {
                    Exceptions.noElementToRemove();
                }
                LongKeyChainedHashMap.this.remove(this.currEntry.getKey());
                this.currEntry = null;
            }
        };
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(long key) {
        Entry<E> e = this.getEntry(key);
        return e != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (int i = 0; i < this.data.length; ++i) {
                Entry<E> e = this.data[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
            }
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                Entry<E> e = this.data[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    @Override
    public E get(long key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry<E> e = this.searchList(this.data[index], key);
        return e != null ? (E)e.value : null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public E remove(long key) {
        E value;
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry<E> e = this.searchList(this.data[index], key);
        if (e != null) {
            this.data[index] = this.removeList(this.data[index], e);
            value = e.value;
            --this.size;
        } else {
            value = null;
        }
        return value;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        LongKeyMapIterator<E> i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeLong(i.getKey());
            s.writeObject(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = this.makeEntryArray(s.readInt());
        for (int i = 0; i < this.size; ++i) {
            long key = s.readLong();
            Object value = s.readObject();
            int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
            Entry<Object> e = new Entry<Object>(key, value);
            e.next = this.data[index];
            this.data[index] = e;
        }
    }

    private class ValueCollection
    extends AbstractCollection<E> {
        private ValueCollection() {
        }

        @Override
        public void clear() {
            LongKeyChainedHashMap.this.clear();
        }

        @Override
        public boolean contains(Object v) {
            return LongKeyChainedHashMap.this.containsValue(v);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                Entry<E> currEntry = null;
                int nextList = this.nextList(0);
                Entry<E> nextEntry;
                {
                    this.nextEntry = this.nextList == -1 ? null : LongKeyChainedHashMap.this.data[this.nextList];
                }

                int nextList(int index) {
                    while (index < LongKeyChainedHashMap.this.data.length && LongKeyChainedHashMap.this.data[index] == null) {
                        ++index;
                    }
                    return index < LongKeyChainedHashMap.this.data.length ? index : -1;
                }

                @Override
                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                @Override
                public E next() {
                    if (this.nextEntry == null) {
                        Exceptions.endOfIterator();
                    }
                    this.currEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    if (this.nextEntry == null) {
                        this.nextList = this.nextList(this.nextList + 1);
                        if (this.nextList != -1) {
                            this.nextEntry = LongKeyChainedHashMap.this.data[this.nextList];
                        }
                    }
                    return this.currEntry.value;
                }

                @Override
                public void remove() {
                    if (this.currEntry == null) {
                        Exceptions.noElementToRemove();
                    }
                    LongKeyChainedHashMap.this.remove(this.currEntry.getKey());
                    this.currEntry = null;
                }
            };
        }

        @Override
        public int size() {
            return LongKeyChainedHashMap.this.size;
        }
    }

    private class KeySet
    extends AbstractLongSet {
        private KeySet() {
        }

        @Override
        public void clear() {
            LongKeyChainedHashMap.this.clear();
        }

        @Override
        public boolean contains(long v) {
            return LongKeyChainedHashMap.this.getEntry(v) != null;
        }

        @Override
        public LongIterator iterator() {
            return new LongIterator(){
                Entry<E> currEntry = null;
                int nextList = this.nextList(0);
                Entry<E> nextEntry;
                {
                    this.nextEntry = this.nextList == -1 ? null : LongKeyChainedHashMap.this.data[this.nextList];
                }

                int nextList(int index) {
                    while (index < LongKeyChainedHashMap.this.data.length && LongKeyChainedHashMap.this.data[index] == null) {
                        ++index;
                    }
                    return index < LongKeyChainedHashMap.this.data.length ? index : -1;
                }

                @Override
                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                @Override
                public long next() {
                    if (this.nextEntry == null) {
                        Exceptions.endOfIterator();
                    }
                    this.currEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    if (this.nextEntry == null) {
                        this.nextList = this.nextList(this.nextList + 1);
                        if (this.nextList != -1) {
                            this.nextEntry = LongKeyChainedHashMap.this.data[this.nextList];
                        }
                    }
                    return this.currEntry.key;
                }

                @Override
                public void remove() {
                    if (this.currEntry == null) {
                        Exceptions.noElementToRemove();
                    }
                    LongKeyChainedHashMap.this.remove(this.currEntry.getKey());
                    this.currEntry = null;
                }
            };
        }

        @Override
        public boolean remove(long v) {
            boolean result = LongKeyChainedHashMap.this.containsKey(v);
            if (result) {
                LongKeyChainedHashMap.this.remove(v);
            }
            return result;
        }

        @Override
        public int size() {
            return LongKeyChainedHashMap.this.size;
        }
    }

    private static class Entry<E> {
        long key;
        E value;
        Entry<E> next;

        Entry(long key, E value) {
            this.key = key;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public E getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            E eval = e.getValue();
            if (eval == null) {
                return e.getKey() == this.key && this.value == null;
            }
            return e.getKey() == this.key && e.getValue().equals(this.value);
        }
    }
}

