/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper.maps;

import jdbm.helper.maps.Exceptions;
import jdbm.helper.maps.LongCollection;
import jdbm.helper.maps.LongIterator;

public abstract class AbstractLongCollection
implements LongCollection {
    protected AbstractLongCollection() {
    }

    @Override
    public boolean add(long v) {
        Exceptions.unsupported("add");
        return false;
    }

    @Override
    public boolean addAll(LongCollection c) {
        LongIterator i = c.iterator();
        boolean result = false;
        while (i.hasNext()) {
            result |= this.add(i.next());
        }
        return result;
    }

    @Override
    public void clear() {
        LongIterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean contains(long v) {
        LongIterator i = this.iterator();
        while (i.hasNext()) {
            if (i.next() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(LongCollection c) {
        LongIterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(long v) {
        LongIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (i.next() != v) continue;
            i.remove();
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean removeAll(LongCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        LongIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(LongCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        LongIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    @Override
    public int size() {
        LongIterator i = this.iterator();
        int size = 0;
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    @Override
    public long[] toArray() {
        return this.toArray(null);
    }

    @Override
    public long[] toArray(long[] a) {
        int size = this.size();
        if (a == null || a.length < size) {
            a = new long[size];
        }
        LongIterator i = this.iterator();
        int index = 0;
        while (i.hasNext()) {
            a[index] = i.next();
            ++index;
        }
        return a;
    }

    @Override
    public void trimToSize() {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        LongIterator i = this.iterator();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            s.append(i.next());
        }
        s.append(']');
        return s.toString();
    }
}

