/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.xfer.FilePermission;

public final class FileAttributes {
    public static final FileAttributes EMPTY = new FileAttributes();
    private final FileMode mode;
    private final int mask;
    private final long size;
    private final int uid;
    private final int gid;
    private final long atime;
    private final long mtime;
    private final Map<String, String> ext = new HashMap<String, String>();

    private FileAttributes() {
        this.mask = 0;
        this.gid = 0;
        this.uid = 0;
        this.atime = this.mtime = (long)0;
        this.size = this.mtime;
        this.mode = new FileMode(0);
    }

    public FileAttributes(int mask, long size, int uid, int gid, FileMode mode, long atime, long mtime, Map<String, String> ext) {
        this.mask = mask;
        this.size = size;
        this.uid = uid;
        this.gid = gid;
        this.mode = mode;
        this.atime = atime;
        this.mtime = mtime;
        this.ext.putAll(ext);
    }

    public boolean has(Flag flag) {
        return flag.isSet(this.mask);
    }

    public long getSize() {
        return this.size;
    }

    public int getUID() {
        return this.uid;
    }

    public int getGID() {
        return this.gid;
    }

    public FileMode getMode() {
        return this.mode;
    }

    public Set<FilePermission> getPermissions() {
        return this.mode.getPermissions();
    }

    public FileMode.Type getType() {
        return this.mode.getType();
    }

    public long getAtime() {
        return this.atime;
    }

    public long getMtime() {
        return this.mtime;
    }

    public String getExtended(String type) {
        return this.ext.get(type);
    }

    public byte[] toBytes() {
        Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
        buf.putUInt32(this.mask);
        if (this.has(Flag.SIZE)) {
            buf.putUInt64(this.size);
        }
        if (this.has(Flag.UIDGID)) {
            buf.putUInt32(this.uid);
            buf.putUInt32(this.gid);
        }
        if (this.has(Flag.MODE)) {
            buf.putUInt32(this.mode.getMask());
        }
        if (this.has(Flag.ACMODTIME)) {
            buf.putUInt32(this.atime);
            buf.putUInt32(this.mtime);
        }
        if (this.has(Flag.EXTENDED)) {
            buf.putUInt32(this.ext.size());
            for (Map.Entry<String, String> entry : this.ext.entrySet()) {
                buf.putString(entry.getKey());
                buf.putString(entry.getValue());
            }
        }
        return buf.getCompactData();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (this.has(Flag.SIZE)) {
            sb.append("size=").append(this.size).append(";");
        }
        if (this.has(Flag.UIDGID)) {
            sb.append("uid=").append(this.uid).append(",gid=").append(this.gid).append(";");
        }
        if (this.has(Flag.MODE)) {
            sb.append("mode=").append(this.mode.toString()).append(";");
        }
        if (this.has(Flag.ACMODTIME)) {
            sb.append("atime=").append(this.atime).append(",mtime=").append(this.mtime).append(";");
        }
        if (this.has(Flag.EXTENDED)) {
            sb.append("ext=").append(this.ext);
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum Flag {
        SIZE(1),
        UIDGID(2),
        MODE(4),
        ACMODTIME(8),
        EXTENDED(Integer.MIN_VALUE);

        private final int flag;

        private Flag(int flag) {
            this.flag = flag;
        }

        public boolean isSet(int mask) {
            return (mask & this.flag) == this.flag;
        }

        public int get() {
            return this.flag;
        }
    }

    public static class Builder {
        private int mask;
        private long size;
        private long atime;
        private long mtime;
        private FileMode mode = new FileMode(0);
        private int uid;
        private int gid;
        private final Map<String, String> ext = new HashMap<String, String>();

        public Builder withSize(long size) {
            this.mask |= Flag.SIZE.get();
            this.size = size;
            return this;
        }

        public Builder withAtimeMtime(long atime, long mtime) {
            this.mask |= Flag.ACMODTIME.get();
            this.atime = atime;
            this.mtime = mtime;
            return this;
        }

        public Builder withUIDGID(int uid, int gid) {
            this.mask |= Flag.UIDGID.get();
            this.uid = uid;
            this.gid = gid;
            return this;
        }

        public Builder withPermissions(Set<FilePermission> perms) {
            this.mask |= Flag.MODE.get();
            this.mode = new FileMode((this.mode != null ? this.mode.getTypeMask() : 0) | FilePermission.toMask(perms));
            return this;
        }

        public Builder withPermissions(int perms) {
            this.mask |= Flag.MODE.get();
            this.mode = new FileMode((this.mode != null ? this.mode.getTypeMask() : 0) | perms);
            return this;
        }

        public Builder withType(FileMode.Type type) {
            this.mask |= Flag.MODE.get();
            this.mode = new FileMode(type.toMask() | (this.mode != null ? this.mode.getPermissionsMask() : 0));
            return this;
        }

        public Builder withExtended(String type, String data) {
            this.mask |= Flag.EXTENDED.get();
            this.ext.put(type, data);
            return this;
        }

        public Builder withExtended(Map<String, String> ext) {
            this.mask |= Flag.EXTENDED.get();
            this.ext.putAll(ext);
            return this;
        }

        public FileAttributes build() {
            return new FileAttributes(this.mask, this.size, this.uid, this.gid, this.mode, this.atime, this.mtime, this.ext);
        }
    }
}

