/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class Scale
extends Control {
    boolean ignoreResize;
    boolean ignoreSelection;
    static final long TrackBarProc;
    static final TCHAR TrackBarClass;
    boolean createdAsRTL;

    public Scale(Composite parent, int style) {
        super(parent, Scale.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.CallWindowProc(TrackBarProc, hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        return Scale.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidthInPixels();
        int width = border * 2;
        int height = border * 2;
        RECT rect = new RECT();
        OS.SendMessage(this.handle, 1049, 0L, rect);
        if ((this.style & 0x100) != 0) {
            width += OS.GetSystemMetrics(21) * 10;
            int scrollY = OS.GetSystemMetrics(3);
            height += rect.top * 2 + scrollY + scrollY / 3;
        } else {
            int scrollX = OS.GetSystemMetrics(2);
            width += rect.left * 2 + scrollX + scrollX / 3;
            height += OS.GetSystemMetrics(20) * 10;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state |= 0x300;
        OS.SendMessage(this.handle, 1032, 0L, 100L);
        OS.SendMessage(this.handle, 1045, 0L, 10L);
        OS.SendMessage(this.handle, 1044, 10L, 0L);
        this.createdAsRTL = (this.style & 0x4000000) != 0;
    }

    @Override
    int defaultForeground() {
        return OS.GetSysColor(15);
    }

    public int getIncrement() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 1026, 0L, 0L);
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 1025, 0L, 0L);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 1046, 0L, 0L);
    }

    public int getSelection() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 1024, 0L, 0L);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void setBackgroundImage(long hImage) {
        super.setBackgroundImage(hImage);
        this.ignoreResize = true;
        OS.SendMessage(this.handle, 5, 0L, 0L);
        this.ignoreResize = false;
    }

    @Override
    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        this.ignoreResize = true;
        OS.SendMessage(this.handle, 5, 0L, 0L);
        this.ignoreResize = false;
    }

    @Override
    void setBoundsInPixels(int x, int y, int width, int height, int flags, boolean defer) {
        super.setBoundsInPixels(x, y, width, height, flags &= 0xFFFFFFDF, true);
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        if (increment < 1) {
            return;
        }
        int minimum = (int)OS.SendMessage(this.handle, 1025, 0L, 0L);
        int maximum = (int)OS.SendMessage(this.handle, 1026, 0L, 0L);
        if (increment > maximum - minimum) {
            return;
        }
        OS.SendMessage(this.handle, 1047, 0L, increment);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = (int)OS.SendMessage(this.handle, 1025, 0L, 0L);
        if (0 <= minimum && minimum < value) {
            OS.SendMessage(this.handle, 1032, 1L, value);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        int maximum = (int)OS.SendMessage(this.handle, 1026, 0L, 0L);
        if (0 <= value && value < maximum) {
            OS.SendMessage(this.handle, 1031, 1L, value);
        }
    }

    public void setPageIncrement(int pageIncrement) {
        this.checkWidget();
        if (pageIncrement < 1) {
            return;
        }
        int minimum = (int)OS.SendMessage(this.handle, 1025, 0L, 0L);
        int maximum = (int)OS.SendMessage(this.handle, 1026, 0L, 0L);
        if (pageIncrement > maximum - minimum) {
            return;
        }
        OS.SendMessage(this.handle, 1045, 0L, pageIncrement);
        OS.SendMessage(this.handle, 1044, (long)pageIncrement, 0L);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.SendMessage(this.handle, 1029, 1L, value);
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle() | 0x10000 | 8 | 1;
        if ((this.style & 0x100) != 0) {
            return bits | 0 | 0x400;
        }
        return bits | 2;
    }

    @Override
    TCHAR windowClass() {
        return TrackBarClass;
    }

    @Override
    long windowProc() {
        return TrackBarProc;
    }

    @Override
    LRESULT WM_KEYDOWN(long wParam, long lParam) {
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch ((int)wParam) {
            case 37: 
            case 39: {
                boolean isRTL;
                boolean bl = isRTL = (this.style & 0x4000000) != 0;
                if (isRTL == this.createdAsRTL) break;
                long code = this.callWindowProc(this.handle, 256, wParam == 39L ? 37L : 39L, lParam);
                return new LRESULT(code);
            }
        }
        return result;
    }

    @Override
    LRESULT WM_MOUSEWHEEL(long wParam, long lParam) {
        LRESULT result = super.WM_MOUSEWHEEL(wParam, lParam);
        if (result != null) {
            return result;
        }
        int oldPosition = (int)OS.SendMessage(this.handle, 1024, 0L, 0L);
        this.ignoreSelection = true;
        long code = this.callWindowProc(this.handle, 522, wParam, lParam);
        this.ignoreSelection = false;
        int newPosition = (int)OS.SendMessage(this.handle, 1024, 0L, 0L);
        if (oldPosition != newPosition) {
            this.sendSelectionEvent(13, null, true);
        }
        return new LRESULT(code);
    }

    @Override
    LRESULT WM_PAINT(long wParam, long lParam) {
        boolean fixPaint;
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        boolean bl = fixPaint = this.findBackgroundControl() != null;
        if (!fixPaint && OS.IsAppThemed()) {
            Control control = this.findThemeControl();
            boolean bl2 = fixPaint = control != null;
        }
        if (fixPaint) {
            boolean redraw;
            boolean bl3 = redraw = this.getDrawing() && OS.IsWindowVisible(this.handle);
            if (redraw) {
                OS.SendMessage(this.handle, 11, 0L, 0L);
            }
            this.ignoreResize = true;
            OS.SendMessage(this.handle, 5, 0L, 0L);
            this.ignoreResize = false;
            if (redraw) {
                OS.SendMessage(this.handle, 11, 1L, 0L);
                OS.InvalidateRect(this.handle, null, false);
            }
        }
        return super.WM_PAINT(wParam, lParam);
    }

    @Override
    LRESULT WM_SIZE(long wParam, long lParam) {
        if (this.ignoreResize) {
            return null;
        }
        return super.WM_SIZE(wParam, lParam);
    }

    @Override
    LRESULT wmScrollChild(long wParam, long lParam) {
        int code = OS.LOWORD(wParam);
        switch (code) {
            case 4: 
            case 8: {
                return null;
            }
        }
        if (!this.ignoreSelection) {
            Event event = new Event();
            this.sendSelectionEvent(13, event, true);
        }
        return null;
    }

    static {
        TrackBarClass = new TCHAR(0, "msctls_trackbar32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, TrackBarClass, lpWndClass);
        TrackBarProc = lpWndClass.lpfnWndProc;
        lpWndClass.hInstance = OS.GetModuleHandle(null);
        lpWndClass.style &= 0xFFFFBFFF;
        lpWndClass.style |= 8;
        OS.RegisterClass(TrackBarClass, lpWndClass);
    }
}

