/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerProvider;
import jdbm.helper.CacheAll;
import jdbm.helper.CachePolicy;
import jdbm.helper.DefaultSerializationHandler;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.ExtensibleSerializer;
import jdbm.helper.ExtensibleSerializerSingleton;
import jdbm.helper.ISerializationHandler;
import jdbm.helper.MRU;
import jdbm.helper.MRUNativeLong;
import jdbm.helper.SoftCache;
import jdbm.helper.WeakCache;
import jdbm.helper.compessor.BestCompressionRecordCompressor;
import jdbm.helper.compessor.BestSpeedRecordCompressor;
import jdbm.helper.compessor.DefaultRecordCompressor;
import jdbm.helper.compessor.IRecordCompressor;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.BufferedRecordInstallManager;
import jdbm.recman.CacheRecordManager;
import jdbm.recman.DumpUtility;

public final class Provider
implements RecordManagerProvider {
    private Properties _stickyOptions;
    private long _stickyOptionsId;

    @Override
    public RecordManager createRecordManager(String name, Properties options) throws IOException {
        IRecordCompressor compressor;
        RecordManager recman;
        BaseRecordManager baserecman;
        String value = options.getProperty("dump", "false");
        if (value.equalsIgnoreCase("TRUE")) {
            baserecman = new DumpUtility(name);
            recman = baserecman;
        } else {
            baserecman = new BaseRecordManager(name);
            recman = baserecman;
        }
        value = options.getProperty("jdbm.RecordFile.cleanMRUCapacity");
        if (value != null) {
            int cleanMRUCapacity = Integer.parseInt(value);
            baserecman._file.setCleanMRUCapacity(cleanMRUCapacity);
        }
        if ((value = options.getProperty("jdbm.RecordFile.freeListCapacity")) != null) {
            int freeListCapacity = Integer.parseInt(value);
            baserecman._file.setFreeListCapacity(freeListCapacity);
        }
        if ((value = options.getProperty("jdbm.RecordFile.counterDisplayRate")) != null) {
            int counterDisplayRate = Integer.parseInt(value);
            baserecman._file.setCounterDisplayRate(counterDisplayRate);
        }
        if ((value = options.getProperty("jdbm.disableTransactions", "false")).equalsIgnoreCase("TRUE")) {
            value = options.getProperty("jdbm.disableTransactions.autoCommitInterval", "10000");
            int autoCommitInterval = Integer.parseInt(value);
            value = options.getProperty("jdbm.disableTransactions.syncOnClose", "true");
            boolean syncOnClose = value.equalsIgnoreCase("TRUE");
            baserecman.disableTransactions(autoCommitInterval, syncOnClose);
        }
        if ((value = options.getProperty("jdbm.cache.type", "normal")).equalsIgnoreCase("normal")) {
            value = options.getProperty("jdbm.cache.size", "1000");
            int cacheSize = Integer.parseInt(value);
            MRU<Long, Object> cache = new MRU<Long, Object>(cacheSize);
            recman = new CacheRecordManager(recman, cache);
        } else if (!value.equalsIgnoreCase("none")) {
            int cacheSizeL2;
            int cacheSizeL1;
            boolean nativeLong;
            if (value.equalsIgnoreCase("soft")) {
                CachePolicy l1;
                nativeLong = false;
                value = options.getProperty("jdbm.cache.size", "128");
                cacheSizeL1 = Integer.parseInt(value);
                if (nativeLong) {
                    value = options.getProperty("jdbm.cache.loadFactor", "0.75");
                    double loadFactorL1 = Double.parseDouble(value);
                    l1 = new MRUNativeLong(cacheSizeL1, loadFactorL1);
                } else {
                    value = options.getProperty("jdbm.cache.loadFactor", "0.75");
                    float loadFactorL1 = Float.parseFloat(value);
                    l1 = new MRU(cacheSizeL1, loadFactorL1);
                }
                value = options.getProperty("jdbm.cache.l2.size", "128");
                cacheSizeL2 = Integer.parseInt(value);
                value = options.getProperty("jdbm.cache.l2.loadFactor", "1.5");
                float loadFactorL2 = Float.parseFloat(value);
                SoftCache l2 = new SoftCache(cacheSizeL2, loadFactorL2, l1);
                recman = new CacheRecordManager(recman, l2);
            } else if (value.equalsIgnoreCase("weak")) {
                CachePolicy l1;
                nativeLong = false;
                value = options.getProperty("jdbm.cache.size", "128");
                cacheSizeL1 = Integer.parseInt(value);
                if (nativeLong) {
                    value = options.getProperty("jdbm.cache.loadFactor", "0.75");
                    double loadFactorL1 = Double.parseDouble(value);
                    l1 = new MRUNativeLong(cacheSizeL1, loadFactorL1);
                } else {
                    value = options.getProperty("jdbm.cache.loadFactor", "0.75");
                    float loadFactorL1 = Float.parseFloat(value);
                    l1 = new MRU(cacheSizeL1, loadFactorL1);
                }
                value = options.getProperty("jdbm.cache.l2.size", "128");
                cacheSizeL2 = Integer.parseInt(value);
                value = options.getProperty("jdbm.cache.l2.loadFactor", "1.5");
                float loadFactorL2 = Float.parseFloat(value);
                WeakCache<Long, Object> l2 = new WeakCache<Long, Object>(cacheSizeL2, loadFactorL2, l1);
                recman = new CacheRecordManager(recman, l2);
            } else if (value.equalsIgnoreCase("all")) {
                recman = new CacheRecordManager(recman, new CacheAll<Long, Object>());
            } else {
                throw new IllegalArgumentException("Invalid cache type: " + value);
            }
        }
        if (recman instanceof CacheRecordManager && (value = options.getProperty("jdbm.lazyInsert", "true")).equalsIgnoreCase("true")) {
            ((CacheRecordManager)recman)._lazyInsert = true;
        }
        if ((value = this.getStickyOption(recman, "jdbm.serializer", null)) == null) {
            value = options.getProperty("jdbm.serializer", "default");
        } else {
            String desiredValue = options.getProperty("jdbm.serializer", "default");
            if (!value.equals(desiredValue)) {
                System.err.println("WARN: desired serializer=" + desiredValue + ", but sticky option already set to: " + value);
            }
        }
        String serializerValue = value;
        this.setStickyOption(recman, "jdbm.serializer", value);
        value = this.getStickyOption(recman, "jdbm.compressor", null);
        if (value == null) {
            value = options.getProperty("jdbm.compressor", "none");
        }
        if ("none".equals(value)) {
            compressor = new DefaultRecordCompressor();
        } else if ("bestSpeed".equals(value)) {
            compressor = new BestSpeedRecordCompressor();
        } else if ("bestCompression".equals(value)) {
            compressor = new BestCompressionRecordCompressor();
        } else {
            throw new IllegalArgumentException("option=jdbm.compressor, value=" + value);
        }
        this.setStickyOption(recman, "jdbm.compressor", value);
        baserecman._compressor = compressor;
        this.setupSerializationHandler(options, recman, serializerValue);
        value = options.getProperty("jdbm.bufferedInstalls", "false");
        if (value.equalsIgnoreCase("true")) {
            int wasteMargin = Integer.parseInt(options.getProperty("jdbm.bufferedInstalls.wasteMargin", "128"));
            int wasteMargin2 = Integer.parseInt(options.getProperty("jdbm.bufferedInstalls.wasteMargin2", "256"));
            baserecman._bufMgr = new BufferedRecordInstallManager(baserecman._file, baserecman._logMgr, baserecman._physMgr, baserecman._pageman, wasteMargin, wasteMargin2);
        }
        return recman;
    }

    protected void initStickyOptions(RecordManager recman) throws IOException {
        if (this._stickyOptions == null) {
            this._stickyOptionsId = recman.getRoot(1);
            if (this._stickyOptionsId == 0L) {
                this._stickyOptions = new Properties();
                this._stickyOptionsId = recman.insert(this._stickyOptions, DefaultSerializer.INSTANCE);
                recman.setRoot(1, this._stickyOptionsId);
            } else {
                this._stickyOptions = (Properties)recman.fetch(this._stickyOptionsId, DefaultSerializer.INSTANCE);
            }
        }
    }

    protected void setStickyOption(RecordManager recman, String name, String value) throws IOException {
        if (recman == null || name == null || name.length() == 0 || value == null) {
            throw new IllegalArgumentException();
        }
        this.initStickyOptions(recman);
        String existingValue = this._stickyOptions.getProperty(name);
        if (existingValue != null && !existingValue.equals(value)) {
            throw new IllegalStateException("Sticky option already set: name=" + name + ", value=" + existingValue);
        }
        if (!value.equals(existingValue)) {
            this._stickyOptions.setProperty(name, value);
            recman.update(this._stickyOptionsId, this._stickyOptions, DefaultSerializer.INSTANCE);
            recman.commit();
        }
    }

    protected String getStickyOption(RecordManager recman, String name, String defval) throws IOException {
        this.initStickyOptions(recman);
        String value = this._stickyOptions.getProperty(name, defval);
        return value;
    }

    private void setupSerializationHandler(Properties properties, RecordManager recman, String value) throws IOException {
        ISerializationHandler ser;
        if (value.equalsIgnoreCase("default")) {
            ser = new DefaultSerializationHandler();
        } else if (value.equalsIgnoreCase("extensible")) {
            ExtensibleSerializer extser;
            long recid = recman.getRoot(2);
            if (recid == 0L) {
                extser = ExtensibleSerializer.createInstance(recman);
                recman.setRoot(2, extser.getRecid());
            } else {
                extser = ExtensibleSerializer.load(recman, recid);
            }
            if (properties.getProperty("jdbm.serializer.profile", "false").equalsIgnoreCase("TRUE")) {
                extser.getProfiler().enable(true);
            }
            ExtensibleSerializerSingleton proxy = new ExtensibleSerializerSingleton();
            proxy.setSerializer(recman, extser);
            ser = proxy;
        } else {
            throw new IllegalArgumentException("Invalid value: option=jdbm.serializer, value=" + value);
        }
        ((BaseRecordManager)recman.getBaseRecordManager())._serializer = ser;
    }
}

