/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.PageHeader;
import jdbm.recman.PhysicalRowId;

final class FreeLogicalRowIdPage
extends PageHeader {
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    static final short ELEMS_PER_PAGE = 817;
    private int previousFoundFree = 0;
    private int previousFoundAllocated = 0;
    final PhysicalRowId[] slots = new PhysicalRowId[817];

    FreeLogicalRowIdPage(BlockIo block) {
        super(block);
    }

    static FreeLogicalRowIdPage getFreeLogicalRowIdPageView(BlockIo block) {
        BlockView view = block.getView();
        if (view != null && view instanceof FreeLogicalRowIdPage) {
            return (FreeLogicalRowIdPage)view;
        }
        return new FreeLogicalRowIdPage(block);
    }

    short getCount() {
        return this.block.readShort(18);
    }

    private void setCount(short i) {
        this.block.writeShort(18, i);
    }

    void free(int slot) {
        this.get(slot).setBlock(0L);
        this.setCount((short)(this.getCount() - 1));
        if (slot < this.previousFoundFree) {
            this.previousFoundFree = slot;
        }
    }

    PhysicalRowId alloc(int slot) {
        this.setCount((short)(this.getCount() + 1));
        this.get(slot).setBlock(-1L);
        if (slot < this.previousFoundAllocated) {
            this.previousFoundAllocated = slot;
        }
        return this.get(slot);
    }

    boolean isAllocated(int slot) {
        return this.get(slot).getBlock() > 0L;
    }

    boolean isFree(int slot) {
        return !this.isAllocated(slot);
    }

    PhysicalRowId get(int slot) {
        if (this.slots[slot] == null) {
            this.slots[slot] = new PhysicalRowId(this.block, this.slotToOffset(slot));
        }
        return this.slots[slot];
    }

    private short slotToOffset(int slot) {
        return (short)(20 + slot * 10);
    }

    int getFirstFree() {
        while (this.previousFoundFree < 817) {
            if (this.isFree(this.previousFoundFree)) {
                return this.previousFoundFree;
            }
            ++this.previousFoundFree;
        }
        return -1;
    }

    int getFirstAllocated() {
        while (this.previousFoundAllocated < 817) {
            if (this.isAllocated(this.previousFoundAllocated)) {
                return this.previousFoundAllocated;
            }
            ++this.previousFoundAllocated;
        }
        return -1;
    }
}

