/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.IOException;
import jdbm.RecordManager;
import jdbm.helper.FastIterator;
import jdbm.htree.HashDirectory;

public class HTree<K, V> {
    private HashDirectory<K, V> _root;

    private HTree(HashDirectory<K, V> root) {
        this._root = root;
    }

    public static <K, V> HTree<K, V> createInstance(RecordManager recman) throws IOException {
        HashDirectory root = new HashDirectory(0);
        long recid = recman.insert(root);
        root.setPersistenceContext(recman, recid);
        return new HTree(root);
    }

    public static <K, V> HTree<K, V> load(RecordManager recman, long root_recid) throws IOException {
        HashDirectory root = (HashDirectory)recman.fetch(root_recid);
        root.setPersistenceContext(recman, root_recid);
        HTree<K, V> tree = new HTree<K, V>(root);
        return tree;
    }

    public synchronized void put(K key, V value) throws IOException {
        this._root.put(key, value);
    }

    public synchronized V get(K key) throws IOException {
        return this._root.get(key);
    }

    public synchronized void remove(K key) throws IOException {
        this._root.remove(key);
    }

    public synchronized FastIterator<K> keys() throws IOException {
        return this._root.keys();
    }

    public synchronized FastIterator<V> values() throws IOException {
        return this._root.values();
    }

    public long getRecid() {
        return this._root.getRecid();
    }
}

