/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.ICacheEntry;
import jdbm.helper.MRU;
import jdbm.helper.Serializer;

public class SoftCache
implements CachePolicy {
    public static final int L1_DEFAULT_CAPACITY = 128;
    public static final int L2_INITIAL_CAPACITY = 128;
    public static final float L2_DEFAULT_LOAD_FACTOR = 1.5f;
    private final ReferenceQueue _clearQueue = new ReferenceQueue();
    private final CachePolicy _internal;
    private final Map _cacheMap;
    private int _capacity;
    private float _loadFactor;
    private int _highTide = 0;
    private int _ninserts = 0;

    public SoftCache() {
        this(new MRU(128));
    }

    public SoftCache(CachePolicy internal) throws NullPointerException {
        this(128, 1.5f, internal);
    }

    public SoftCache(float loadFactor, CachePolicy internal) throws IllegalArgumentException, NullPointerException {
        this(128, loadFactor, internal);
    }

    public SoftCache(int capacity, float loadFactor, CachePolicy internal) throws IllegalArgumentException, NullPointerException {
        if (internal == null) {
            throw new NullPointerException("Internal cache cannot be null.");
        }
        this._internal = internal;
        this._capacity = capacity;
        this._loadFactor = loadFactor;
        this._cacheMap = new HashMap(capacity, loadFactor);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void put(Object key, Object value, boolean dirty, Serializer ser) throws CacheEvictionException {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        this._internal.put(key, value, dirty, ser);
        this.removeClearedEntries();
        this._cacheMap.put(key, new Entry(key, value, dirty, ser, this._clearQueue));
        ++this._ninserts;
        int size = this._cacheMap.size();
        if (size > this._highTide) {
            this._highTide = size;
        }
    }

    public Object get(Object key) {
        Object value = this._internal.get(key);
        if (value != null) {
            return value;
        }
        this.removeClearedEntries();
        Entry entry = (Entry)this._cacheMap.get(key);
        if (entry == null) {
            return null;
        }
        value = entry.getValue();
        if (value == null) {
            return null;
        }
        try {
            this._internal.put(key, value, false, null);
        }
        catch (CacheEvictionException e) {
            this._cacheMap.remove(key);
            return null;
        }
        return value;
    }

    public void remove(Object key) {
        this._cacheMap.remove(key);
        this._internal.remove(key);
    }

    @Override
    public void removeAll() {
        this._cacheMap.clear();
        this._internal.removeAll();
    }

    public Enumeration elements() {
        return this._internal.elements();
    }

    public Enumeration entries() {
        return this._internal.entries();
    }

    @Override
    public void addListener(CachePolicyListener listener) throws IllegalArgumentException {
        this._internal.addListener(listener);
    }

    @Override
    public void removeListener(CachePolicyListener listener) {
        this._internal.removeListener(listener);
    }

    private final void removeClearedEntries() {
        Reference r = this._clearQueue.poll();
        while (r != null) {
            Object key = ((Entry)r).getKey();
            this._cacheMap.remove(key);
            r = this._clearQueue.poll();
        }
    }

    private static final class Entry
    extends SoftReference
    implements ICacheEntry {
        final Object _key;
        boolean _dirty;
        Serializer _ser;

        public Entry(Object key, Object value, boolean dirty, Serializer ser, ReferenceQueue queue) {
            super(value, queue);
            this._key = key;
            this._dirty = dirty;
            this._ser = ser;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this.get();
        }

        @Override
        public boolean isDirty() {
            return this._dirty;
        }

        @Override
        public void setDirty(boolean dirty) {
            this._dirty = dirty;
        }

        public Serializer getSerializer() {
            return this._ser;
        }
    }
}

