/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.IOException;
import jdbm.extser.Stateless;
import jdbm.helper.Conversion;
import jdbm.helper.Serializer;

public class FloatSerializer
implements Serializer<Float>,
Stateless {
    public static final transient Serializer<Float> INSTANCE = new FloatSerializer();
    private static final long serialVersionUID = -2264686724440652750L;

    @Override
    public byte[] serialize(Float obj) throws IOException {
        int bits = Float.floatToRawIntBits(obj.floatValue());
        return Conversion.convertToByteArray(bits);
    }

    @Override
    public Float deserialize(byte[] serialized) throws IOException {
        int bits = Conversion.convertToInt(serialized);
        return new Float(Float.intBitsToFloat(bits));
    }
}

