/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.util.NoSuchElementException;
import jdbm.helper.CacheEntry;
import jdbm.helper.ICacheEntry;
import jdbm.helper.MRU;

class BasicMRUEnumeration<K, V>
implements MRU.ICacheOrderChangeListener<K, V> {
    private final MRU<K, V> cache;
    private CacheEntry<K, V> next;

    BasicMRUEnumeration(MRU<K, V> cache) {
        this.cache = cache;
        this.next = cache._first;
        cache.addCacheOrderChangeListener(this);
    }

    public boolean hasMoreElements() {
        return this.next != null;
    }

    CacheEntry<K, V> _nextElement() {
        if (this.next == null) {
            this.removeListener();
            throw new NoSuchElementException();
        }
        CacheEntry<K, V> ret = this.next;
        this.next = this.next._next;
        if (this.next == null) {
            this.removeListener();
        }
        return ret;
    }

    @Override
    public void willRemove(ICacheEntry<K, V> entry) {
        if (entry == this.next) {
            this.next = this.next._next;
        }
    }

    private void removeListener() {
        this.cache.removeCacheOrderChangeListener(this);
    }
}

