/*
 * Decompiled with CFR 0.152.
 */
package jdbm.extser.profiler;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import jdbm.extser.AbstractExtensibleSerializer;
import jdbm.extser.ISerializer;
import jdbm.extser.NativeType;
import jdbm.extser.Stateless;
import jdbm.extser.profiler.Statistics;
import jdbm.extser.profiler.VersionStatistics;

public class ClassStatistics
extends Statistics {
    public final int classId;
    public final String classname;
    public final boolean stateless;
    public Map versionStatistics;

    public ClassStatistics(AbstractExtensibleSerializer serializer, int classId) {
        super(serializer);
        this.classId = classId;
        if (classId >= 0 && classId <= 17) {
            this.classname = NativeType.asString(classId);
            this.stateless = false;
        } else {
            this.classname = this.getSerializer().getClassName(classId);
            try {
                Class<?> cl = Class.forName(this.classname);
                this.stateless = Stateless.class.isAssignableFrom(cl);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.reset();
    }

    public VersionStatistics get(short versionId, ISerializer serializer) {
        Short versionId2 = new Short(versionId);
        VersionStatistics stats = (VersionStatistics)this.versionStatistics.get(versionId2);
        if (stats == null) {
            stats = new VersionStatistics(this.getSerializer(), versionId, serializer);
            this.versionStatistics.put(versionId2, stats);
        }
        return stats;
    }

    @Override
    public void reset() {
        super.reset();
        this.versionStatistics = new HashMap();
    }

    public void read(ISerializer ser, short version, int nbytes) {
        super.read(nbytes);
        this.get(version, ser).read(nbytes);
    }

    public void write(ISerializer ser, short version, int nbytes) {
        super.write(nbytes);
        this.get(version, ser).write(nbytes);
    }

    @Override
    public void writeOn(PrintStream ps) {
        long avgPerRead = this.nread == 0L ? 0L : this.bytesRead / this.nread;
        long avgPerWrite = this.nwritten == 0L ? 0L : this.bytesWritten / this.nwritten;
        ps.println("class=" + this.classname + (this.stateless ? "(Stateless)" : "") + ", classId=" + this.classId + ", read(" + this.nread + "," + this.bytesRead + "," + avgPerRead + ")" + ", write(" + this.nwritten + "," + this.bytesWritten + "," + avgPerWrite + ")");
        for (VersionStatistics stats : this.versionStatistics.values()) {
            stats.writeOn(ps);
        }
    }
}

