/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Stack;
import net.schmizz.sshj.xfer.FilePermission;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemFile
implements LocalSourceFile,
LocalDestFile {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File file;

    public FileSystemFile(String path) {
        this(new File(path));
    }

    public FileSystemFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws IOException {
        return new FileOutputStream(this.file, append);
    }

    public Iterable<FileSystemFile> getChildren(final LocalFileFilter filter) throws IOException {
        File[] childFiles;
        File[] fileArray = childFiles = filter == null ? this.file.listFiles() : this.file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return filter.accept(new FileSystemFile(file));
            }
        });
        if (childFiles == null) {
            throw new IOException("Error listing files in directory: " + String.valueOf(this));
        }
        ArrayList<FileSystemFile> children = new ArrayList<FileSystemFile>();
        for (File f : childFiles) {
            children.add(new FileSystemFile(f));
        }
        return children;
    }

    @Override
    public boolean providesAtimeMtime() {
        return true;
    }

    @Override
    public long getLastAccessTime() throws IOException {
        return System.currentTimeMillis() / 1000L;
    }

    @Override
    public long getLastModifiedTime() throws IOException {
        return this.file.lastModified() / 1000L;
    }

    @Override
    public int getPermissions() throws IOException {
        if (this.isDirectory()) {
            return 493;
        }
        if (this.isFile()) {
            return 420;
        }
        throw new IOException("Unsupported file type");
    }

    @Override
    public void setLastAccessedTime(long t) throws IOException {
    }

    @Override
    public void setLastModifiedTime(long t) throws IOException {
        if (!this.file.setLastModified(t * 1000L)) {
            this.log.warn("Could not set last modified time for {} to {}", (Object)this.file, (Object)t);
        }
    }

    @Override
    public void setPermissions(int perms) throws IOException {
        boolean r = this.file.setReadable(FilePermission.USR_R.isIn(perms), !FilePermission.OTH_R.isIn(perms) && !FilePermission.GRP_R.isIn(perms));
        boolean w = this.file.setWritable(FilePermission.USR_W.isIn(perms), !FilePermission.OTH_W.isIn(perms) && !FilePermission.GRP_W.isIn(perms));
        boolean x = this.file.setExecutable(FilePermission.USR_X.isIn(perms), !FilePermission.OTH_X.isIn(perms) && !FilePermission.GRP_X.isIn(perms));
        if (!(r && w && x)) {
            this.log.warn("Could not set permissions for {} to {}", (Object)this.file, (Object)Integer.toString(perms, 16));
        }
    }

    @Override
    public FileSystemFile getChild(String name) {
        this.validateIsChildPath(name);
        return new FileSystemFile(new File(this.file, name));
    }

    private void validateIsChildPath(String name) {
        String[] split = name.split("/");
        Stack<String> s = new Stack<String>();
        for (String component : split) {
            if (component == null || component.isEmpty() || ".".equals(component)) continue;
            if ("..".equals(component) && !s.isEmpty()) {
                s.pop();
                continue;
            }
            if ("..".equals(component)) {
                throw new IllegalArgumentException("Cannot traverse higher than " + String.valueOf(this.file) + " to get child " + name);
            }
            s.push(component);
        }
    }

    @Override
    public FileSystemFile getTargetFile(String filename) throws IOException {
        FileSystemFile f = this;
        if (f.isDirectory()) {
            f = f.getChild(filename);
        }
        if (!f.getFile().exists()) {
            if (!f.getFile().createNewFile()) {
                throw new IOException("Could not create: " + String.valueOf(this.file));
            }
        } else if (f.isDirectory()) {
            throw new IOException("A directory by the same name already exists: " + String.valueOf(f));
        }
        return f;
    }

    @Override
    public FileSystemFile getTargetDirectory(String dirname) throws IOException {
        FileSystemFile f = this;
        if (f.getFile().exists()) {
            if (f.isDirectory()) {
                if (!f.getName().equals(dirname)) {
                    f = f.getChild(dirname);
                }
            } else {
                throw new IOException(String.valueOf(f) + " - already exists as a file; directory required");
            }
        }
        if (!f.getFile().exists() && !f.getFile().mkdir()) {
            throw new IOException("Failed to create directory: " + String.valueOf(f));
        }
        return f;
    }

    public boolean equals(Object other) {
        return other instanceof FileSystemFile && this.file.equals(((FileSystemFile)other).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.file.toString();
    }
}

